<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Мой профиль';
$this->params['breadcrumbs'][] = $this->title;

// Функция для форматирования даты
function formatDate($timestamp) {
    if (empty($timestamp)) {
        return '';
    }
    return date('d.m.Y', $timestamp);
}
?>

<div class="profile-index">
    <div class="row">
        <div class="col-md-3">
            <div class="card mb-3">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-user-circle fa-5x text-primary"></i>
                    </div>
                    <h5><?= Html::encode($model->full_name) ?></h5>
                    <p class="text-muted"><?= Html::encode($model->email) ?></p>
                    <p class="text-muted"><?= Html::encode($model->phone) ?></p>
                    <?= Html::a('Сменить пароль', ['change-password'], ['class' => 'btn btn-outline-primary btn-sm']) ?>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Быстрые действия</h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <?= Html::a('<i class="fas fa-tachometer-alt mr-2"></i> Передать показания', ['/meter-reading/create'], ['class' => 'text-decoration-none']) ?>
                        </li>
                        <li class="mb-2">
                            <?= Html::a('<i class="fas fa-history mr-2"></i> История показаний', ['/meter-reading'], ['class' => 'text-decoration-none']) ?>
                        </li>
                        <li>
                            <?= Html::a('<i class="fas fa-home mr-2"></i> На главную', ['/site/index'], ['class' => 'text-decoration-none']) ?>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="col-md-9">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">Редактирование профиля</h4>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'profile-form',
                        'fieldConfig' => [
                            'template' => "{label}\n{input}\n{error}",
                            'labelOptions' => ['class' => 'control-label'],
                            'inputOptions' => ['class' => 'form-control'],
                            'errorOptions' => ['class' => 'text-danger'],
                        ],
                    ]); ?>

                    <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                        <div style="flex: 1;">
                            <?= $form->field($model, 'full_name')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div style="flex: 1;">
                            <?= $form->field($model, 'phone')->widget(\yii\widgets\MaskedInput::class, [
                                'mask' => '8(999)999-99-99',
                                'options' => ['class' => 'form-control']
                            ]) ?>
                        </div>
                    </div>

                    <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                        <div style="flex: 1;">
                            <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'type' => 'email']) ?>
                        </div>
                        <div style="flex: 1;">
                            <?= $form->field($model, 'residents_count')->textInput(['type' => 'number', 'min' => 1]) ?>
                        </div>
                    </div>

                    <?= $form->field($model, 'address')->textarea(['rows' => 3]) ?>

                    <div class="form-group" style="margin-top: 20px;">
                        <?= Html::submitButton('Сохранить изменения', ['class' => 'btn btn-primary']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
            
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="mb-0">Информация о профиле</h4>
                </div>
                <div class="card-body">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                        <div>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Дата регистрации:</p>
                            <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                <?= formatDate($model->created_at) ?>
                            </p>
                        </div>
                        
                        <div>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Последнее обновление:</p>
                            <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                <?= formatDate($model->updated_at) ?>
                            </p>
                        </div>
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Адрес проживания:</p>
                        <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                            <?= nl2br(Html::encode($model->address)) ?>
                        </p>
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Количество проживающих:</p>
                        <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                            <?= Html::encode($model->residents_count) ?> чел.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -15px;
}

.col-md-3, .col-md-9 {
    padding: 0 15px;
}

.col-md-3 {
    width: 25%;
}

.col-md-9 {
    width: 75%;
}

@media (max-width: 768px) {
    .col-md-3, .col-md-9 {
        width: 100%;
    }
}

.form-control {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 1rem;
    transition: border-color 0.3s;
}

.form-control:focus {
    outline: none;
    border-color: #3498db;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    color: #e74c3c;
    font-size: 0.9rem;
    margin-top: 5px;
    display: block;
}

.control-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: #2c3e50;
}

.btn-outline-primary {
    background: transparent;
    border: 1px solid #3498db;
    color: #3498db;
    padding: 8px 16px;
    border-radius: 4px;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s;
}

.btn-outline-primary:hover {
    background: #3498db;
    color: white;
}

.text-decoration-none {
    text-decoration: none;
    color: #3498db;
}

.text-decoration-none:hover {
    text-decoration: underline;
}

.text-muted {
    color: #666;
}

.list-unstyled {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mr-2 {
    margin-right: 8px;
}

.mb-0 {
    margin-bottom: 0;
}

.mb-2 {
    margin-bottom: 8px;
}

.mb-3 {
    margin-bottom: 16px;
}

.mt-4 {
    margin-top: 24px;
}
</style>