<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Показания #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Мои показания', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

// Функции для форматирования
function formatDecimal($value, $decimals = 3) {
    if ($value === null || $value === '') {
        return '';
    }
    return number_format($value, $decimals, ',', ' ');
}

function formatCurrency($value) {
    if ($value === null || $value === '') {
        return '';
    }
    return number_format($value, 2, ',', ' ') . ' ₽';
}

function formatDateTime($timestamp) {
    if (empty($timestamp)) {
        return '';
    }
    
    if (is_string($timestamp)) {
        $timestamp = strtotime($timestamp);
    }
    
    return date('d.m.Y H:i', $timestamp);
}

function formatLongDate($date) {
    $months = [
        1 => 'января', 2 => 'февраля', 3 => 'марта', 4 => 'апреля',
        5 => 'мая', 6 => 'июня', 7 => 'июля', 8 => 'августа',
        9 => 'сентября', 10 => 'октября', 11 => 'ноября', 12 => 'декабря'
    ];
    
    if (empty($date)) {
        return '';
    }
    
    if (is_string($date)) {
        $timestamp = strtotime($date);
    } else {
        $timestamp = $date;
    }
    
    $day = date('j', $timestamp);
    $month = $months[date('n', $timestamp)];
    $year = date('Y', $timestamp);
    
    return $day . ' ' . $month . ' ' . $year . ' года';
}
?>

<div class="meter-reading-view">
    <div style="max-width: 800px; margin: 0 auto;">
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h1 class="card-title" style="margin: 0;"><?= Html::encode($this->title) ?></h1>
                <span style="display: inline-block; padding: 6px 16px; border-radius: 4px; font-weight: bold;
                      background: <?= $model->status === 'Новая' ? '#fff3cd' : 
                                   ($model->status === 'Показания приняты' ? '#d1ecf1' : 
                                   ($model->status === 'Оплачено' ? '#d4edda' : '#f8d7da')) ?>; 
                      color: <?= $model->status === 'Новая' ? '#856404' : 
                              ($model->status === 'Показания приняты' ? '#0c5460' : 
                              ($model->status === 'Оплачено' ? '#155724' : '#721c24')) ?>; 
                      border: 1px solid <?= $model->status === 'Новая' ? '#ffeaa7' : 
                                          ($model->status === 'Показания приняты' ? '#bee5eb' : 
                                          ($model->status === 'Оплачено' ? '#c3e6cb' : '#f5c6cb')) ?>;">
                    <?= Html::encode($model->status) ?>
                </span>
            </div>
            <div class="card-body">
                <!-- Основная информация -->
                <div style="margin-bottom: 30px;">
                    <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                        Основная информация
                    </h3>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                        <div>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Дата передачи:</p>
                            <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                <?= formatLongDate($model->reading_date) ?>
                            </p>
                        </div>
                        <div>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Услуга:</p>
                            <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                <?= Html::encode($model->serviceCategory->name ?? '') ?>
                            </p>
                        </div>
                        <div>
                            <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Дата создания:</p>
                            <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                <?= formatDateTime($model->created_at) ?>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Показания и расчет -->
                <div style="margin-bottom: 30px;">
                    <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                        Показания и расчет
                    </h3>
                    <div style="background: #f8f9fa; border-radius: 8px; padding: 20px;">
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 20px;">
                            <div style="text-align: center;">
                                <p style="margin: 0 0 10px 0; color: #666; font-size: 0.9rem;">Предыдущие показания</p>
                                <div style="background: white; border-radius: 6px; padding: 15px; border: 2px solid #e0e0e0;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem; color: #3498db;">
                                        <?= formatDecimal($model->previous_reading, 3) ?>
                                    </p>
                                    <p style="margin: 5px 0 0 0; color: #999; font-size: 0.9rem;">
                                        <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                            
                            <div style="text-align: center; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-arrow-right" style="font-size: 2rem; color: #95a5a6;"></i>
                            </div>
                            
                            <div style="text-align: center;">
                                <p style="margin: 0 0 10px 0; color: #666; font-size: 0.9rem;">Текущие показания</p>
                                <div style="background: white; border-radius: 6px; padding: 15px; border: 2px solid #3498db;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem; color: #2c3e50;">
                                        <?= formatDecimal($model->current_reading, 3) ?>
                                    </p>
                                    <p style="margin: 5px 0 0 0; color: #999; font-size: 0.9rem;">
                                        <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                            <div>
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Расход:</p>
                                <div style="background: white; border-radius: 6px; padding: 12px; border: 1px solid #e0e0e0;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.2rem; color: #e67e22;">
                                        <?= formatDecimal($model->consumption, 3) ?>
                                        <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                            
                            <div>
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Тариф:</p>
                                <div style="background: white; border-radius: 6px; padding: 12px; border: 1px solid #e0e0e0;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.2rem; color: #9b59b6;">
                                        <?= formatCurrency($model->serviceCategory->tariff ?? 0) ?>
                                        / <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Итоговая сумма -->
                <div>
                    <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                        Итоговая сумма
                    </h3>
                    <div style="background: linear-gradient(135deg, #27ae60, #2ecc71); border-radius: 8px; padding: 25px; text-align: center;">
                        <p style="margin: 0 0 10px 0; color: rgba(255,255,255,0.9); font-size: 1.1rem;">Сумма к оплате:</p>
                        <p style="margin: 0; font-weight: bold; font-size: 2.5rem; color: white;">
                            <?= formatCurrency($model->amount) ?>
                        </p>
                        <p style="margin: 10px 0 0 0; color: rgba(255,255,255,0.8); font-size: 0.9rem;">
                            Расчет: <?= formatDecimal($model->consumption, 3) ?> 
                            × <?= formatCurrency($model->serviceCategory->tariff ?? 0) ?> 
                            = <?= formatCurrency($model->amount) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-top: 30px; display: flex; gap: 15px; justify-content: center;">
            <?= Html::a('Вернуться к списку', ['index'], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Передать новые показания', ['create'], ['class' => 'btn btn-success']) ?>
        </div>
    </div>
</div>