<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Заявка #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Панель администратора', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-view">
    <div style="max-width: 1000px; margin: 0 auto;">
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h1 class="card-title" style="margin: 0;"><?= Html::encode($this->title) ?></h1>
                <span style="display: inline-block; padding: 6px 16px; border-radius: 4px; font-weight: bold;
                      background: <?= $model->status === 'Новая' ? '#fff3cd' : 
                                   ($model->status === 'Показания приняты' ? '#d1ecf1' : 
                                   ($model->status === 'Оплачено' ? '#d4edda' : '#f8d7da')) ?>; 
                      color: <?= $model->status === 'Новая' ? '#856404' : 
                              ($model->status === 'Показания приняты' ? '#0c5460' : 
                              ($model->status === 'Оплачено' ? '#155724' : '#721c24')) ?>; 
                      border: 1px solid <?= $model->status === 'Новая' ? '#ffeaa7' : 
                                          ($model->status === 'Показания приняты' ? '#bee5eb' : 
                                          ($model->status === 'Оплачено' ? '#c3e6cb' : '#f5c6cb')) ?>;">
                    <?= Html::encode($model->status) ?>
                </span>
            </div>
            <div class="card-body">
                <?php $form = ActiveForm::begin([
                    'id' => 'admin-form',
                    'options' => ['class' => 'form']
                ]); ?>

                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                    <!-- Информация о пользователе -->
                    <div>
                        <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                            Информация о пользователе
                        </h3>
                        <div style="background: #f8f9fa; border-radius: 8px; padding: 20px;">
                            <div style="margin-bottom: 15px;">
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">ФИО:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= Html::encode($model->user->full_name ?? '') ?>
                                </p>
                            </div>
                            <div style="margin-bottom: 15px;">
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Телефон:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= Html::encode($model->user->phone ?? '') ?>
                                </p>
                            </div>
                            <div style="margin-bottom: 15px;">
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Email:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= Html::encode($model->user->email ?? '') ?>
                                </p>
                            </div>
                            <div>
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Адрес:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= nl2br(Html::encode($model->user->address ?? '')) ?>
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Детали заявки -->
                    <div>
                        <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                            Детали заявки
                        </h3>
                        <div style="background: #f8f9fa; border-radius: 8px; padding: 20px;">
                            <div style="margin-bottom: 15px;">
                                <?= $form->field($model, 'status')->dropDownList(
                                    \app\models\MeterReading::getStatuses(),
                                    ['class' => 'form-control']
                                )->label('Статус заявки') ?>
                            </div>
                            <div style="margin-bottom: 15px;">
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Услуга:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= Html::encode($model->serviceCategory->name ?? '') ?>
                                    (<?= Html::encode($model->serviceCategory->unit ?? '') ?>)
                                </p>
                            </div>
                            <div style="margin-bottom: 15px;">
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Дата передачи:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= Yii::$app->formatter->asDate($model->reading_date, 'long') ?>
                                </p>
                            </div>
                            <div>
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Дата создания:</p>
                                <p style="margin: 0; font-weight: bold; font-size: 1.1rem;">
                                    <?= Yii::$app->formatter->asDateTime($model->created_at) ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Показания -->
                <div style="margin-bottom: 30px;">
                    <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                        Показания счетчика
                    </h3>
                    <div style="background: #f8f9fa; border-radius: 8px; padding: 20px;">
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 20px;">
                            <div style="text-align: center;">
                                <p style="margin: 0 0 10px 0; color: #666; font-size: 0.9rem;">Предыдущие показания</p>
                                <div style="background: white; border-radius: 6px; padding: 15px; border: 2px solid #e0e0e0;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem; color: #3498db;">
                                        <?= Yii::$app->formatter->asDecimal($model->previous_reading, 3) ?>
                                    </p>
                                    <p style="margin: 5px 0 0 0; color: #999; font-size: 0.9rem;">
                                        <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                            
                            <div style="text-align: center; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-arrow-right" style="font-size: 2rem; color: #95a5a6;"></i>
                            </div>
                            
                            <div style="text-align: center;">
                                <p style="margin: 0 0 10px 0; color: #666; font-size: 0.9rem;">Текущие показания</p>
                                <div style="background: white; border-radius: 6px; padding: 15px; border: 2px solid #3498db;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem; color: #2c3e50;">
                                        <?= Yii::$app->formatter->asDecimal($model->current_reading, 3) ?>
                                    </p>
                                    <p style="margin: 5px 0 0 0; color: #999; font-size: 0.9rem;">
                                        <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                            <div>
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Расход:</p>
                                <div style="background: white; border-radius: 6px; padding: 12px; border: 1px solid #e0e0e0;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.2rem; color: #e67e22;">
                                        <?= Yii::$app->formatter->asDecimal($model->consumption, 3) ?>
                                        <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                            
                            <div>
                                <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Тариф:</p>
                                <div style="background: white; border-radius: 6px; padding: 12px; border: 1px solid #e0e0e0;">
                                    <p style="margin: 0; font-weight: bold; font-size: 1.2rem; color: #9b59b6;">
                                        <?= Yii::$app->formatter->asCurrency($model->serviceCategory->tariff ?? 0) ?>
                                        / <?= Html::encode($model->serviceCategory->unit ?? '') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Итоговая сумма -->
                <div style="margin-bottom: 30px;">
                    <h3 style="color: #2c3e50; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0;">
                        Финансовые расчеты
                    </h3>
                    <div style="background: linear-gradient(135deg, #27ae60, #2ecc71); border-radius: 8px; padding: 25px; text-align: center;">
                        <p style="margin: 0 0 10px 0; color: rgba(255,255,255,0.9); font-size: 1.1rem;">Сумма к оплате:</p>
                        <p style="margin: 0; font-weight: bold; font-size: 2.5rem; color: white;">
                            <?= Yii::$app->formatter->asCurrency($model->amount) ?>
                        </p>
                        <p style="margin: 10px 0 0 0; color: rgba(255,255,255,0.8); font-size: 0.9rem;">
                            Расчет: <?= Yii::$app->formatter->asDecimal($model->consumption, 3) ?> 
                            × <?= Yii::$app->formatter->asCurrency($model->serviceCategory->tariff ?? 0) ?> 
                            = <?= Yii::$app->formatter->asCurrency($model->amount) ?>
                        </p>
                    </div>
                </div>

                <div style="display: flex; gap: 15px; margin-top: 30px;">
                    <?= Html::submitButton('Сохранить изменения', [
                        'class' => 'btn btn-primary',
                        'name' => 'save-button'
                    ]) ?>
                    
                    <?= Html::a('Вернуться к списку', ['index'], ['class' => 'btn btn-link']) ?>
                    
                    <?php if ($model->status === 'Новая'): ?>
                        <?= Html::a('Принять показания', '#', [
                            'class' => 'btn btn-success',
                            'id' => 'accept-reading',
                            'onclick' => 'document.getElementById("meterreading-status").value="Показания приняты";document.getElementById("admin-form").submit();return false;'
                        ]) ?>
                        
                        <?= Html::a('Отклонить с ошибкой', '#', [
                            'class' => 'btn btn-danger',
                            'id' => 'reject-reading',
                            'onclick' => 'document.getElementById("meterreading-status").value="Ошибка в переданных показаниях";document.getElementById("admin-form").submit();return false;'
                        ]) ?>
                    <?php endif; ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>