<?php

namespace app\components;

class Formatter
{
    /**
     * Форматирует число как валюту
     */
    public static function asCurrency($value, $currency = '₽', $decimalSeparator = ',', $thousandSeparator = ' ')
    {
        if ($value === null || $value === '') {
            return '';
        }
        
        $value = floatval($value);
        $formatted = number_format($value, 2, $decimalSeparator, $thousandSeparator);
        
        return $formatted . ' ' . $currency;
    }
    
    /**
     * Форматирует число с десятичными знаками
     */
    public static function asDecimal($value, $decimals = 3)
    {
        if ($value === null || $value === '') {
            return '';
        }
        
        $value = floatval($value);
        return number_format($value, $decimals, ',', ' ');
    }
    
    /**
     * Форматирует дату
     */
    public static function asDate($timestamp, $format = 'd.m.Y')
    {
        if (empty($timestamp)) {
            return '';
        }
        
        if (is_numeric($timestamp)) {
            return date($format, $timestamp);
        } elseif (is_string($timestamp)) {
            return date($format, strtotime($timestamp));
        }
        
        return $timestamp;
    }
    
    /**
     * Форматирует дату и время
     */
    public static function asDateTime($timestamp, $format = 'd.m.Y H:i')
    {
        if (empty($timestamp)) {
            return '';
        }
        
        if (is_numeric($timestamp)) {
            return date($format, $timestamp);
        } elseif (is_string($timestamp)) {
            return date($format, strtotime($timestamp));
        }
        
        return $timestamp;
    }
    
    /**
     * Форматирует дату в длинном формате
     */
    public static function asLongDate($timestamp)
    {
        $months = [
            1 => 'января', 2 => 'февраля', 3 => 'марта', 4 => 'апреля',
            5 => 'мая', 6 => 'июня', 7 => 'июля', 8 => 'августа',
            9 => 'сентября', 10 => 'октября', 11 => 'ноября', 12 => 'декабря'
        ];
        
        if (empty($timestamp)) {
            return '';
        }
        
        if (is_string($timestamp)) {
            $timestamp = strtotime($timestamp);
        }
        
        $day = date('j', $timestamp);
        $month = $months[date('n', $timestamp)];
        $year = date('Y', $timestamp);
        
        return $day . ' ' . $month . ' ' . $year . ' года';
    }
}