<?php

namespace app\models;

use Yii;
use yii\base\Model;

class SignupForm extends Model
{
    public $full_name;
    public $phone;
    public $email;
    public $address;
    public $residents_count;
    public $password;
    public $password_repeat;
    public $agree_terms;

    public function rules()
    {
        return [
            [['full_name', 'phone', 'email', 'address', 'residents_count', 'password', 'password_repeat', 'agree_terms'], 'required'],
            [['full_name'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s]+$/u'],
            [['phone'], 'match', 'pattern' => '/^8\(\d{3}\)\d{3}-\d{2}-\d{2}$/'],
            [['email'], 'email'],
            [['residents_count'], 'integer', 'min' => 1],
            [['password'], 'string', 'min' => 10],
            [['password_repeat'], 'compare', 'compareAttribute' => 'password'],
            [['agree_terms'], 'compare', 'compareValue' => true, 'message' => 'Необходимо согласиться с правилами'],
            [['email', 'phone'], 'unique', 'targetClass' => User::class],
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }

        $user = new User();
        $user->full_name = $this->full_name;
        $user->phone = $this->phone;
        $user->email = $this->email;
        $user->address = $this->address;
        $user->residents_count = $this->residents_count;
        $user->password = $this->password;
        
        return $user->save() ? $user : null;
    }

    public function attributeLabels()
    {
        return [
            'full_name' => 'ФИО',
            'phone' => 'Телефон',
            'email' => 'Email',
            'address' => 'Адрес проживания',
            'residents_count' => 'Количество проживающих',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
            'agree_terms' => 'Согласие с правилами',
        ];
    }
}