<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%service_category}}`.
 */
class m260205_184839_create_service_category_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%service_category}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(100)->notNull()->comment('Название услуги'),
            'unit' => $this->string(20)->notNull()->comment('Единица измерения'),
            'tariff' => $this->decimal(10, 2)->notNull()->comment('Тариф'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        // Добавляем базовые категории услуг
        $this->batchInsert('{{%service_category}}', 
            ['name', 'unit', 'tariff', 'created_at', 'updated_at'], 
            [
                ['Электричество', 'кВт·ч', 5.03, time(), time()],
                ['Газ', 'м³', 7.39, time(), time()],
                ['Вода', 'м³', 48.24, time(), time()],
                ['Холодная вода', 'м³', 45.00, time(), time()],
                ['Горячая вода', 'м³', 198.00, time(), time()],
                ['Отопление', 'Гкал', 2200.00, time(), time()],
            ]
        );

        $this->createIndex('idx-service_category-name', '{{%service_category}}', 'name');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%service_category}}');
    }
}
