<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%user}}`.
 */
class m260205_170404_create_user_table extends Migration
{
    /**
     * {@inheritdoc}
     */
   public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'full_name' => $this->string(255)->notNull()->comment('ФИО'),
            'phone' => $this->string(20)->notNull()->unique()->comment('Телефон'),
            'email' => $this->string(255)->notNull()->unique()->comment('Email'),
            'address' => $this->text()->notNull()->comment('Адрес проживания'),
            'residents_count' => $this->integer()->notNull()->defaultValue(1)->comment('Количество проживающих'),
            'password_hash' => $this->string(255)->notNull()->comment('Хэш пароля'),
            'auth_key' => $this->string(32)->null()->comment('Ключ авторизации'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        // Добавляем индекс для телефона (уже есть unique, но для скорости)
        $this->createIndex('idx-user-phone', '{{%user}}', 'phone');
        $this->createIndex('idx-user-email', '{{%user}}', 'email');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%user}}');
    }
}
