<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\LoginForm;
use app\models\User;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Главная страница
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Страница входа
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        
        if ($model->load(Yii::$app->request->post())) {
            if ($model->login()) {
                Yii::$app->session->setFlash('success', 'Вы успешно авторизовались!');
                return $this->goBack();
            } else {
                Yii::$app->session->setFlash('error', 'Ошибка авторизации. Проверьте телефон и пароль.');
            }
        }

        $model->password = '';
        
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /**
     * Страница регистрации
     */
    public function actionSignup()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new User();
        $model->scenario = User::SCENARIO_REGISTER;

        if ($model->load(Yii::$app->request->post())) {
            if ($model->save()) {
                // Автоматически авторизуем пользователя после регистрации
                Yii::$app->user->login($model);
                
                Yii::$app->session->setFlash('success', 'Регистрация прошла успешно! Добро пожаловать!');
                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Ошибка регистрации. Проверьте правильность заполнения полей.');
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }

    /**
     * Выход
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();
        Yii::$app->session->setFlash('success', 'Вы успешно вышли из системы.');
        return $this->goHome();
    }
}