<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\User;

class ProfileController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Просмотр и редактирование профиля
     */
    public function actionIndex()
    {
        $model = Yii::$app->user->identity;
        $model->scenario = User::SCENARIO_UPDATE;

        if ($model->load(Yii::$app->request->post())) {
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Профиль успешно обновлен.');
                return $this->refresh();
            } else {
                Yii::$app->session->setFlash('error', 'Ошибка при обновлении профиля.');
            }
        }

        return $this->render('index', [
            'model' => $model,
        ]);
    }

    /**
     * Смена пароля
     */
    public function actionChangePassword()
    {
        $model = Yii::$app->user->identity;
        $model->scenario = User::SCENARIO_CHANGE_PASSWORD;

        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate()) {
                $model->setPassword($model->password);
                if ($model->save(false)) {
                    Yii::$app->session->setFlash('success', 'Пароль успешно изменен.');
                    return $this->redirect(['index']);
                }
            }
        }

        $model->password = '';
        $model->password_repeat = '';
        
        return $this->render('change-password', [
            'model' => $model,
        ]);
    }
}