<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use app\models\MeterReading;
use app\models\ServiceCategory;

class MeterReadingController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * Список всех показаний пользователя
     */
    public function actionIndex()
    {
        $userId = Yii::$app->user->id;
        
        $dataProvider = new ActiveDataProvider([
            'query' => MeterReading::find()
                ->where(['user_id' => $userId])
                ->joinWith(['serviceCategory'])
                ->orderBy(['reading_date' => SORT_DESC, 'created_at' => SORT_DESC]),
            'pagination' => [
                'pageSize' => 20,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Передача новых показаний
     */
    public function actionCreate()
{
    $model = new MeterReading();
    $model->user_id = Yii::$app->user->id;
    $model->reading_date = date('Y-m-d');

    // Получаем категории услуг
    $categories = ServiceCategory::getAllCategories();
    
    // Получаем последние показания для каждой категории
    $lastReadings = [];
    foreach ($categories as $category) {
        $lastReading = MeterReading::getLastReading(Yii::$app->user->id, $category->id);
        $lastReadings[$category->id] = $lastReading ? $lastReading->current_reading : 0;
    }

    if ($model->load(Yii::$app->request->post())) {
        // Устанавливаем предыдущие показания
        $model->previous_reading = $lastReadings[$model->service_category_id] ?? 0;
        
        if ($model->save()) {
            // Форматируем сумму без форматтера
            $amount = number_format($model->amount, 2, ',', ' ');
            Yii::$app->session->setFlash('success', "Показания успешно переданы. Сумма к оплате: {$amount} ₽");
            return $this->redirect(['index']);
        } else {
            Yii::$app->session->setFlash('error', 'Ошибка при передаче показаний.');
        }
    }

    return $this->render('create', [
        'model' => $model,
        'categories' => $categories,
        'lastReadings' => $lastReadings,
    ]);
}

    /**
     * Просмотр деталей показаний
     */
    public function actionView($id)
    {
        $model = MeterReading::findOne($id);
        
        if (!$model || $model->user_id !== Yii::$app->user->id) {
            throw new \yii\web\ForbiddenHttpException('У вас нет доступа к этим данным.');
        }

        return $this->render('view', [
            'model' => $model,
        ]);
    }
}